
#include "EmuApple.h"
#include "AppleDiskII.h"

class TAppleGCRCodec
{
public:
	TAppleGCRCodec();
	void nibblizeTrack(int volume, int track, 
		TAppleCookedTrack in, TAppleRawTrack out);
	int denibblizeTrack(int volume, int track, 
		TAppleRawTrack in, TAppleCookedTrack out);
private:
	byte	GCR_decoding_table[256];
	byte	GCR_buffer[256];
	byte	GCR_buffer2[86];

	int		Position;
	byte	*Track_Nibble;

	int	Physical_Sector[16];

/*  function prototypes */

	void init_GCR_table(void);
	byte gcr_read_nibble(void);
	void gcr_write_nibble( byte );
	void decode62( byte* );
	void encode62( byte* );
	void FM_encode( byte );
	byte FM_decode(void);
	void write_sync( int );
	int read_address_field( int*, int*, int* );
	void write_address_field( int, int, int );
	int read_data_field(void);
	void write_data_field(void);
};

